<?php
/**
 * Plugin Name: iNotary – Per-Page Schema in Header
 * Description: Adds a per-page field to paste schema (or any raw HTML) into the <head> for that page only.
 * Version: 1.0.0
 */

if (!defined('ABSPATH')) exit;

class INotary_Schema_Header {
    const META_KEY = '_inotary_schema_in_head';

    public function __construct() {
        add_action('add_meta_boxes', [$this, 'add_box']);
        add_action('save_post_page', [$this, 'save'], 10, 2);
        add_action('wp_head', [$this, 'output'], 999);
    }

    public function add_box() {
        add_meta_box(
            'inotary_schema_in_head_box',
            'Post schema in header here',
            [$this, 'render'],
            'page',
            'normal',
            'high'
        );
    }

    public function render($post) {
        if (!current_user_can('unfiltered_html')) {
            echo '<p><strong>You do not have permission to add raw header HTML.</strong></p>';
            return;
        }

        wp_nonce_field('inotary_schema_in_head_save', 'inotary_schema_in_head_nonce');
        $value = get_post_meta($post->ID, self::META_KEY, true);

        echo '<p>Paste schema or raw HTML to inject into the page <code>&lt;head&gt;</code>.</p>';
        echo '<textarea name="inotary_schema_in_head" style="width:100%;min-height:220px;font-family:monospace;">'
            . esc_textarea($value) .
            '</textarea>';
    }

    public function save($post_id, $post) {
        if (defined('DOING_AUTOSAVE') && DOING_AUTOSAVE) return;
        if (wp_is_post_revision($post_id)) return;

        if (!isset($_POST['inotary_schema_in_head_nonce']) ||
            !wp_verify_nonce($_POST['inotary_schema_in_head_nonce'], 'inotary_schema_in_head_save')) {
            return;
        }

        if (!current_user_can('unfiltered_html')) return;

        $raw = isset($_POST['inotary_schema_in_head']) ? trim((string) $_POST['inotary_schema_in_head']) : '';

        if ($raw === '') {
            delete_post_meta($post_id, self::META_KEY);
        } else {
            update_post_meta($post_id, self::META_KEY, $raw);
        }
    }

    public function output() {
        if (!is_page()) return;

        $post_id = get_queried_object_id();
        if (!$post_id) return;

        $raw = get_post_meta($post_id, self::META_KEY, true);
        if (!$raw) return;

        echo "\n<!-- iNotary schema injection -->\n";
        echo $raw . "\n";
        echo "<!-- /iNotary schema injection -->\n";
    }
}

new INotary_Schema_Header();
